/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartPart;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.ClickCallbackGenerator;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Callback;
import com.roguewave.chart.core.v2_1.graphics.ClickablePolygon;
import com.roguewave.chart.core.v2_1.graphics.ColorArray;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3D;
import com.roguewave.chart.core.v2_1.graphics.SortTreeInternal;
import com.roguewave.chart.core.v2_1.graphics.SortTreeLeaf;
import com.roguewave.chart.core.v2_1.graphics.SortTreeNode;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.LineSegment;
import java.awt.Color;

public class LineChartRow
extends ChartPart {
    private static final double defaultDepth = 0.8;
    private static final double defaultThickness = 0.02;

    public LineChartRow(ChartProperties properties, DataModel data, int row, Transform3D transform, ColorArray colors) {
        Color color = properties.getColor(row, 0, colors.color(row), 0.0);
        double depth = properties.getProperty("PartDepth", 0.8);
        double thickness = properties.getProperty("LineThickness", 0.02);
        boolean outline = properties.getProperty("LineSegmentOutlines", true);
        ClickCallbackGenerator generator = properties.getClickCallbackGenerator();
        int dataLength = data.getColumnCount();
        double x = -((double)dataLength - 1.0) / 2.0;
        Transform3D trans = new Transform3D(transform, Transform3D.translate(x, (thickness *= properties.getChartHeight()) / (double)2, 0.0));
        double right = properties.getScaledValue(data, row, 0);
        SortTreeNode stnPrevious = null;
        for (int column = 0; column < dataLength - 1; ++column) {
            SortTreeLeaf stlNew;
            double left = right;
            right = properties.getScaledValue(data, row, column + 1);
            trans = new Transform3D(transform, Transform3D.translate(x, thickness / (double)2, 0.0));
            LineSegment segment = new LineSegment(left, right, thickness, depth, trans, color, outline);
            if (generator == null) {
                stlNew = new SortTreeLeaf(segment.polygons());
                this.add2DPolygons(segment.front());
            } else {
                stlNew = new SortTreeLeaf();
                int[] rowArr = new int[]{row, row};
                int[] colArr = new int[]{column, column + 1};
                Callback callback = generator.generateCallback(data, rowArr, colArr);
                Polygon3D[] polygons = segment.polygons();
                for (int i = 0; i < polygons.length; ++i) {
                    stlNew.addClickable(new ClickablePolygon(polygons[i], callback));
                }
                this.add2DClickable(new ClickablePolygon(segment.front()[0].zeroZ(), callback));
            }
            Point3D[] testPoints = new Point3D[]{new Point3D(x, 0.0, 0.0), new Point3D(x, 0.0, 1.0), new Point3D(x, 1.0, 1.0)};
            stnPrevious = stnPrevious == null ? stlNew : new SortTreeInternal(stnPrevious, stlNew, testPoints);
            x += 1.0;
        }
        this.setSortTree(stnPrevious);
    }
}

